/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.util.Map;
import org.apache.uima.ResourceFactory;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;

public class CustomResourceFactory_impl
implements ResourceFactory {
    @Override
    public Resource produceResource(Class<? extends Resource> aResourceClass, ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (aSpecifier instanceof CustomResourceSpecifier) {
            Resource resource;
            Class<?> resourceClass;
            String className = ((CustomResourceSpecifier)aSpecifier).getResourceClassName();
            ClassLoader loader = null;
            ResourceManager resMgr = null;
            if (aAdditionalParams != null) {
                resMgr = (ResourceManager)aAdditionalParams.get("RESOURCE_MANAGER");
            }
            if (resMgr != null) {
                loader = resMgr.getExtensionClassLoader();
            }
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            try {
                resourceClass = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException("class_not_found", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
            }
            if (!aResourceClass.isAssignableFrom(resourceClass)) {
                throw new ResourceInitializationException("resource_does_not_implement_interface", new Object[]{className, aResourceClass.getName(), aSpecifier.getSourceUrlString()});
            }
            try {
                resource = (Resource)resourceClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
            }
            catch (IllegalAccessException e) {
                throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
            }
            boolean initializeOK = false;
            try {
                initializeOK = resource.initialize(aSpecifier, aAdditionalParams);
            }
            catch (Exception e) {
                throw new ResourceInitializationException("exception_when_initializing_custom_resource", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
            }
            catch (Throwable e) {
                throw new ResourceInitializationException("throwable_when_initializing_custom_resource", new Object[]{className, aSpecifier.getSourceUrlString()}, e);
            }
            if (initializeOK) {
                return resource;
            }
            throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{className, aSpecifier.getSourceUrlString()});
        }
        return null;
    }
}

