/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.tika.parser.wordperfect.WP6Charsets;
import org.apache.tika.parser.wordperfect.WPDocumentAreaExtractor;
import org.apache.tika.parser.wordperfect.WPInputStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class WP6DocumentAreaExtractor
extends WPDocumentAreaExtractor {
    private static final Map<Integer, Integer> FIXED_LENGTH_FUNCTION_SIZES = MapUtils.putAll(new HashMap(), new Integer[]{240, 4, 241, 5, 242, 3, 243, 3, 244, 3, 245, 3, 246, 4, 247, 4, 248, 4, 249, 5, 250, 5, 251, 6, 252, 6, 253, 8, 254, 8});

    WP6DocumentAreaExtractor() {
    }

    @Override
    protected void extract(int c, WPInputStream in, StringBuilder out, XHTMLContentHandler xhtml) throws IOException, SAXException {
        if (c > 0 && c <= 32) {
            out.append(WP6Charsets.DEFAULT_EXTENDED_INTL_CHARS[c]);
        } else if (c >= 33 && c <= 126) {
            out.append((char)c);
        } else if (c == 128) {
            out.append(' ');
        } else if (c == 129) {
            out.append('\u00a0');
        } else if (c == 129) {
            out.append('-');
        } else if (c == 135 || c == 137) {
            this.endParagraph(out, xhtml);
        } else if (c == 138) {
            this.skipUntilChar(in, 139);
        } else if (c == 198) {
            out.append('\t');
        } else if (c >= 180 && c <= 207) {
            this.endParagraph(out, xhtml);
        } else if (c >= 208 && c <= 239) {
            int subgroup = in.readWP();
            int functionSize = in.readWPShort();
            for (int i = 0; i < functionSize - 4; ++i) {
                in.readWP();
            }
            if (c == 208) {
                if (subgroup >= 1 && subgroup <= 3) {
                    out.append(' ');
                } else if (subgroup == 10) {
                    out.append('\t');
                } else if (subgroup >= 4 && subgroup <= 19) {
                    this.endParagraph(out, xhtml);
                } else if (subgroup >= 20 && subgroup <= 22) {
                    out.append(' ');
                } else if (subgroup >= 23 && subgroup <= 28) {
                    this.endParagraph(out, xhtml);
                }
            } else if (c == 213) {
                out.append(' ');
            } else if (c == 224) {
                out.append('\t');
            }
        } else if (c == 240) {
            int charval = in.readWP();
            int charset = in.readWP();
            in.readWP();
            WP6Charsets.append(out, charset, charval);
        } else if (c >= 241 && c <= 254) {
            in.skipWPByte(FIXED_LENGTH_FUNCTION_SIZES.get(c) - 1);
        } else if (c == 255) {
            this.skipUntilChar(in, c);
        }
    }
}

