/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.jdk8.ChronoField;
import org.apache.sis.internal.jdk8.DateTimeParseException;
import org.apache.sis.internal.jdk8.OffsetDateTime;
import org.apache.sis.internal.jdk8.OffsetTime;
import org.apache.sis.internal.jdk8.Temporal;
import org.apache.sis.internal.jdk8.UnsupportedTemporalTypeException;

public final class LocalDate
extends Temporal {
    private static final GregorianCalendar CALENDAR = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);

    private LocalDate(long l) {
        super(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalDate of(int n, int n2, int n3) {
        long l;
        GregorianCalendar gregorianCalendar = CALENDAR;
        synchronized (gregorianCalendar) {
            CALENDAR.clear();
            CALENDAR.set(n, n2 - 1, n3);
            l = CALENDAR.getTimeInMillis();
        }
        return new LocalDate(l);
    }

    public OffsetDateTime atTime(OffsetTime offsetTime) {
        return new OffsetDateTime(this.millis + offsetTime.millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalDate parse(String string) {
        Date date;
        try {
            SimpleDateFormat simpleDateFormat = FORMAT;
            synchronized (simpleDateFormat) {
                date = FORMAT.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw new DateTimeParseException(parseException.getLocalizedMessage());
        }
        return new LocalDate(date.getTime());
    }

    public long toEpochDay() {
        return this.millis / 86400000L;
    }

    public long getLong(ChronoField chronoField) {
        switch (chronoField) {
            case INSTANT_SECONDS: {
                return this.millis / 1000L;
            }
        }
        throw new UnsupportedTemporalTypeException(chronoField.toString());
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

