/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.csv.Assertions;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;

public final class CSVPrinter
implements Flushable,
Closeable {
    private final Appendable out;
    private final CSVFormat format;
    private boolean newRecord = true;

    public CSVPrinter(Appendable out, CSVFormat format) throws IOException {
        Assertions.notNull(out, "out");
        Assertions.notNull(format, "format");
        this.out = out;
        this.format = format;
        if (format.getHeader() != null) {
            this.printRecord(format.getHeader());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
    }

    public void print(Object value) throws IOException {
        String nullString;
        String strValue = value == null ? ((nullString = this.format.getNullString()) == null ? "" : nullString) : value.toString();
        this.print(value, strValue, 0, strValue.length());
    }

    private void print(Object object, CharSequence value, int offset, int len) throws IOException {
        if (!this.newRecord) {
            this.out.append(this.format.getDelimiter());
        }
        if (this.format.isQuoteCharacterSet()) {
            this.printAndQuote(object, value, offset, len);
        } else if (this.format.isEscapeCharacterSet()) {
            this.printAndEscape(value, offset, len);
        } else {
            this.out.append(value, offset, offset + len);
        }
        this.newRecord = false;
    }

    private void printAndEscape(CharSequence value, int offset, int len) throws IOException {
        int pos;
        int start = offset;
        int end = offset + len;
        char delim = this.format.getDelimiter();
        char escape = this.format.getEscapeCharacter().charValue();
        for (pos = offset; pos < end; ++pos) {
            char c = value.charAt(pos);
            if (c != '\r' && c != '\n' && c != delim && c != escape) continue;
            if (pos > start) {
                this.out.append(value, start, pos);
            }
            if (c == '\n') {
                c = 'n';
            } else if (c == '\r') {
                c = 'r';
            }
            this.out.append(escape);
            this.out.append(c);
            start = pos + 1;
        }
        if (pos > start) {
            this.out.append(value, start, pos);
        }
    }

    private void printAndQuote(Object object, CharSequence value, int offset, int len) throws IOException {
        char c;
        boolean quote = false;
        int start = offset;
        int pos = offset;
        int end = offset + len;
        char delimChar = this.format.getDelimiter();
        char quoteChar = this.format.getQuoteCharacter().charValue();
        QuoteMode quoteModePolicy = this.format.getQuoteMode();
        if (quoteModePolicy == null) {
            quoteModePolicy = QuoteMode.MINIMAL;
        }
        switch (quoteModePolicy) {
            case ALL: {
                quote = true;
                break;
            }
            case NON_NUMERIC: {
                quote = !(object instanceof Number);
                break;
            }
            case NONE: {
                this.printAndEscape(value, offset, len);
                return;
            }
            case MINIMAL: {
                if (len <= 0) {
                    if (this.newRecord) {
                        quote = true;
                    }
                } else {
                    c = value.charAt(pos);
                    if (this.newRecord && (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z')) {
                        quote = true;
                    } else if (c <= '#') {
                        quote = true;
                    } else {
                        while (pos < end) {
                            c = value.charAt(pos);
                            if (c == '\n' || c == '\r' || c == quoteChar || c == delimChar) {
                                quote = true;
                                break;
                            }
                            ++pos;
                        }
                        if (!quote && (c = value.charAt(pos = end - 1)) <= ' ') {
                            quote = true;
                        }
                    }
                }
                if (quote) break;
                this.out.append(value, start, end);
                return;
            }
            default: {
                throw new IllegalStateException("Unexpected Quote value: " + (Object)((Object)quoteModePolicy));
            }
        }
        if (!quote) {
            this.out.append(value, start, end);
            return;
        }
        this.out.append(quoteChar);
        while (pos < end) {
            c = value.charAt(pos);
            if (c == quoteChar) {
                this.out.append(value, start, pos + 1);
                start = pos;
            }
            ++pos;
        }
        this.out.append(value, start, pos);
        this.out.append(quoteChar);
    }

    public void printComment(String comment) throws IOException {
        if (!this.format.isCommentMarkerSet()) {
            return;
        }
        if (!this.newRecord) {
            this.println();
        }
        this.out.append(this.format.getCommentMarker().charValue());
        this.out.append(' ');
        block4: for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < comment.length() && comment.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    this.println();
                    this.out.append(this.format.getCommentMarker().charValue());
                    this.out.append(' ');
                    continue block4;
                }
                default: {
                    this.out.append(c);
                }
            }
        }
        this.println();
    }

    public void println() throws IOException {
        String recordSeparator = this.format.getRecordSeparator();
        if (recordSeparator != null) {
            this.out.append(recordSeparator);
        }
        this.newRecord = true;
    }

    public void printRecord(Iterable<?> values) throws IOException {
        for (Object value : values) {
            this.print(value);
        }
        this.println();
    }

    public void printRecord(Object ... values) throws IOException {
        for (Object value : values) {
            this.print(value);
        }
        this.println();
    }

    public void printRecords(Iterable<?> values) throws IOException {
        for (Object value : values) {
            if (value instanceof Object[]) {
                this.printRecord((Object[])value);
                continue;
            }
            if (value instanceof Iterable) {
                this.printRecord((Iterable)value);
                continue;
            }
            this.printRecord(value);
        }
    }

    public void printRecords(Object ... values) throws IOException {
        for (Object value : values) {
            if (value instanceof Object[]) {
                this.printRecord((Object[])value);
                continue;
            }
            if (value instanceof Iterable) {
                this.printRecord((Iterable)value);
                continue;
            }
            this.printRecord(value);
        }
    }

    public void printRecords(ResultSet resultSet) throws SQLException, IOException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                this.print(resultSet.getString(i));
            }
            this.println();
        }
    }

    public Appendable getOut() {
        return this.out;
    }
}

