/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryArrow;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryArrowAndCircle;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircle;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleConnect;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryCircleCross;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryDiamond;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryParenthesis;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryPlus;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactorySquarre;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryTriangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LinkDecor {
    NONE(2, false, 0.0),
    EXTENDS(30, false, 2.0),
    COMPOSITION(15, true, 1.3),
    AGREGATION(15, false, 1.3),
    ARROW(10, true, 0.5),
    ARROW_TRIANGLE(10, true, 0.8),
    ARROW_AND_CIRCLE(10, false, 0.5),
    CIRCLE(0, false, 0.5),
    CIRCLE_CONNECT(0, false, 0.5),
    PARENTHESIS(0, false, 1.0),
    SQUARRE(0, false, 0.5),
    CIRCLE_CROSS(0, false, 0.5),
    PLUS(0, false, 1.5),
    SQUARRE_toberemoved(30, false, 0.0);

    private final double arrowSize;
    private final int margin;
    private final boolean fill;

    private LinkDecor(int n2, boolean bl, double d) {
        this.margin = n2;
        this.fill = bl;
        this.arrowSize = d;
    }

    public int getMargin() {
        return this.margin;
    }

    public boolean isFill() {
        return this.fill;
    }

    public double getArrowSize() {
        return this.arrowSize;
    }

    public ExtremityFactory getExtremityFactory() {
        if (this == PLUS) {
            return new ExtremityFactoryPlus();
        }
        if (this == ARROW_TRIANGLE) {
            return new ExtremityFactoryTriangle();
        }
        if (this == CIRCLE_CROSS) {
            return new ExtremityFactoryCircleCross();
        }
        if (this == ARROW) {
            return new ExtremityFactoryArrow();
        }
        if (this == ARROW_AND_CIRCLE) {
            return new ExtremityFactoryArrowAndCircle();
        }
        if (this == AGREGATION) {
            return new ExtremityFactoryDiamond(false);
        }
        if (this == COMPOSITION) {
            return new ExtremityFactoryDiamond(true);
        }
        if (this == CIRCLE) {
            return new ExtremityFactoryCircle();
        }
        if (this == SQUARRE) {
            return new ExtremityFactorySquarre();
        }
        if (this == PARENTHESIS) {
            return new ExtremityFactoryParenthesis();
        }
        if (this == CIRCLE_CONNECT) {
            return new ExtremityFactoryCircleConnect();
        }
        return null;
    }
}

