/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMargedBottom;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ConnectionVerticalDown;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileFactoryDelegatorAssembly
extends FtileFactoryDelegator {
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorAssembly(FtileFactory ftileFactory, ISkinParam iSkinParam) {
        super(ftileFactory, iSkinParam);
    }

    public Ftile assembly(Ftile ftile, Ftile ftile2) {
        double d = 35.0;
        TextBlock textBlock = this.getTextBlock(this.getInLinkRenderingDisplay(ftile2));
        StringBounder stringBounder = this.getStringBounder();
        if (textBlock != null) {
            d += textBlock.calculateDimension(stringBounder).getHeight();
        }
        FtileMargedBottom ftileMargedBottom = new FtileMargedBottom(ftile, d);
        Ftile ftile3 = super.assembly(ftileMargedBottom, ftile2);
        FtileGeometry ftileGeometry = ftile.calculateDimension(stringBounder);
        if (!ftileGeometry.hasPointOut()) {
            return ftile3;
        }
        UTranslate uTranslate = ftile3.getTranslateFor(ftileMargedBottom, stringBounder);
        Point2D point2D = ftileGeometry.translate(uTranslate).getPointOut();
        UTranslate uTranslate2 = ftile3.getTranslateFor(ftile2, stringBounder);
        Point2D point2D2 = ftile2.calculateDimension(stringBounder).translate(uTranslate2).getPointIn();
        HtmlColor htmlColor = this.getInLinkRenderingColor(ftile2);
        ConnectionVerticalDown connectionVerticalDown = new ConnectionVerticalDown(ftile, ftile2, point2D, point2D2, htmlColor, textBlock);
        ftile3 = FtileUtils.addConnection(ftile3, connectionVerticalDown);
        if (textBlock != null) {
            double d2 = ftile3.calculateDimension(stringBounder).getWidth();
            double d3 = connectionVerticalDown.getMaxX(stringBounder);
            double d4 = (d3 - d2) * 2.0;
            ftile3 = new FtileMinWidth(ftile3, d4);
        }
        return ftile3;
    }

    private TextBlock getTextBlock(Display display) {
        if (display == null) {
            return null;
        }
        ISkinParam iSkinParam = this.getSkinParam();
        UFont uFont = iSkinParam.getFont(FontParam.ACTIVITY_ARROW, null);
        HtmlColor htmlColor = this.rose.getFontColor(iSkinParam, FontParam.ACTIVITY_ARROW);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, htmlColor);
        return TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, null);
    }
}

