/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Americanize
implements Function<HasWord, HasWord> {
    private static boolean DEFAULT_CAPITALIZE_TIMEX;
    private boolean capitalizeTimex = true;
    public static final int DONT_CAPITALIZE_TIMEX = 1;
    private static final Pattern[] pats;
    private static final String[] OUR_EXCEPTIONS;
    private static final Pattern[] excepts;
    private static final String[] reps;
    private static final String[] converters;
    private static final String[] converted;
    private static final String[] timexConverters;
    private static final String[] timexConverted;
    private static final HashMap<String, String> mapping;
    private static final HashMap<String, String> timexMapping;

    public Americanize() {
    }

    public Americanize(int flags) {
        if ((flags & 1) != 0) {
            this.capitalizeTimex = false;
        }
    }

    @Override
    public HasWord apply(HasWord w) {
        String str = w.word();
        String outStr = Americanize.americanize(str, this.capitalizeTimex);
        if (!outStr.equals(str)) {
            w.setWord(outStr);
        }
        return w;
    }

    public static String americanize(String str) {
        return Americanize.americanize(str, DEFAULT_CAPITALIZE_TIMEX);
    }

    public static String americanize(String str, boolean capitalizeTimex) {
        if (capitalizeTimex && timexMapping.containsKey(str)) {
            return timexMapping.get(str);
        }
        if (mapping.containsKey(str)) {
            return mapping.get(str);
        }
        for (int i = 0; i < pats.length; ++i) {
            Matcher m;
            Matcher me;
            Pattern ex = excepts[i];
            if (ex != null && (me = ex.matcher(str)).find() || !(m = pats[i].matcher(str)).find()) continue;
            return m.replaceAll(reps[i]);
        }
        return str;
    }

    public String toString() {
        return "Americanize[capitalizeTimex is " + DEFAULT_CAPITALIZE_TIMEX + "; " + "mapping has " + mapping.size() + " mappings; " + "timexMapping has " + timexMapping.size() + " mappings]";
    }

    public static void main(String[] args) throws IOException {
        System.err.println(new Americanize());
        System.err.println();
        if (args.length == 0) {
            String line;
            BufferedReader buf = new BufferedReader(new InputStreamReader(System.in));
            while ((line = buf.readLine()) != null) {
                for (String w : line.split("\\s+")) {
                    System.out.print(Americanize.americanize(w) + " ");
                }
                System.out.println();
            }
            buf.close();
        }
        for (String arg : args) {
            System.out.print(arg);
            System.out.print(" --> ");
            System.out.println(Americanize.americanize(arg));
        }
    }

    static {
        int i;
        DEFAULT_CAPITALIZE_TIMEX = true;
        pats = new Pattern[]{Pattern.compile("haem(at)?o"), Pattern.compile("aemia$"), Pattern.compile("([lL]euk)aem"), Pattern.compile("programme(s?)$"), Pattern.compile("^([a-z]{3,})our(s?)$")};
        OUR_EXCEPTIONS = new String[]{"abatjour", "beflour", "bonjour", "calambour", "carrefour", "cornflour", "contour", "de[tv]our", "dortour", "dyvour", "downpour", "giaour", "glamour", "holour", "inpour", "outpour", "pandour", "paramour", "pompadour", "recontour", "repour", "ryeflour", "sompnour", "tambour", "troubadour", "tregetour", "velour"};
        excepts = new Pattern[]{null, null, null, null, Pattern.compile(StringUtils.join(OUR_EXCEPTIONS, "|"))};
        reps = new String[]{"hem$1o", "emia", "$1em", "program$1", "$1or$2"};
        converters = new String[]{"anaesthetic", "analogue", "analogues", "analyse", "analysed", "analysing", "armoured", "cancelled", "cancelling", "candour", "capitalise", "capitalised", "capitalisation", "centre", "chimaeric", "clamour", "coloured", "colouring", "colourful", "defence", "Defence", "discolour", "discolours", "discoloured", "discolouring", "encyclopaedia", "endeavour", "endeavours", "endeavoured", "endeavouring", "fervour", "favour", "favours", "favoured", "favouring", "favourite", "favourites", "fibre", "fibres", "finalise", "finalised", "finalising", "flavour", "flavours", "flavoured", "flavouring", "glamour", "grey", "harbour", "harbours", "homologue", "homologues", "honour", "honours", "honoured", "honouring", "honourable", "humour", "humours", "humoured", "humouring", "kerb", "labelled", "labelling", "labour", "Labour", "labours", "laboured", "labouring", "leant", "learnt", "localise", "localised", "manoeuvre", "manoeuvres", "maximise", "maximised", "maximising", "meagre", "minimise", "minimised", "minimising", "modernise", "modernised", "modernising", "misdemeanour", "misdemeanours", "neighbour", "neighbours", "neighbourhood", "neighbourhoods", "oestrogen", "oestrogens", "organisation", "organisations", "penalise", "penalised", "popularise", "popularised", "popularises", "popularising", "practise", "practised", "pressurise", "pressurised", "pressurises", "pressurising", "realise", "realised", "realising", "realises", "recognise", "recognised", "recognising", "recognises", "rumoured", "rumouring", "savour", "savours", "savoured", "savouring", "splendour", "splendours", "theatre", "theatres", "titre", "titres", "travelled", "travelling"};
        converted = new String[]{"anesthetic", "analog", "analogs", "analyze", "analyzed", "analyzing", "armored", "canceled", "canceling", "candor", "capitalize", "capitalized", "capitalization", "center", "chimeric", "clamor", "colored", "coloring", "colorful", "defense", "Defense", "discolor", "discolors", "discolored", "discoloring", "encyclopedia", "endeavor", "endeavors", "endeavored", "endeavoring", "fervor", "favor", "favors", "favored", "favoring", "favorite", "favorites", "fiber", "fibers", "finalize", "finalized", "finalizing", "flavor", "flavors", "flavored", "flavoring", "glamour", "gray", "harbor", "harbors", "homolog", "homologs", "honor", "honors", "honored", "honoring", "honorable", "humor", "humors", "humored", "humoring", "curb", "labeled", "labeling", "labor", "Labor", "labors", "labored", "laboring", "leaned", "learned", "localize", "localized", "maneuver", "maneuvers", "maximize", "maximized", "maximizing", "meager", "minimize", "minimized", "minimizing", "modernize", "modernized", "modernizing", "misdemeanor", "misdemeanors", "neighbor", "neighbors", "neighborhood", "neighborhoods", "estrogen", "estrogens", "organization", "organizations", "penalize", "penalized", "popularize", "popularized", "popularizes", "popularizing", "practice", "practiced", "pressurize", "pressurized", "pressurizes", "pressurizing", "realize", "realized", "realizing", "realizes", "recognize", "recognized", "recognizing", "recognizes", "rumored", "rumoring", "savor", "savors", "savored", "savoring", "splendor", "splendors", "theater", "theaters", "titer", "titers", "traveled", "traveling"};
        timexConverters = new String[]{"january", "february", "april", "june", "july", "august", "september", "october", "november", "december", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};
        timexConverted = new String[]{"January", "February", "April", "June", "July", "August", "September", "October", "November", "December", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        mapping = new HashMap();
        timexMapping = new HashMap();
        if (converters.length != converted.length || timexConverters.length != timexConverted.length || pats.length != reps.length || pats.length != excepts.length) {
            throw new RuntimeException("Americanize: Bad initialization data");
        }
        for (i = 0; i < converters.length; ++i) {
            mapping.put(converters[i], converted[i]);
        }
        for (i = 0; i < timexConverters.length; ++i) {
            timexMapping.put(timexConverters[i], timexConverted[i]);
        }
    }
}

